define(['angular'], function (angular) {
    'use strict';

    return function (RequestService, BaseFHIRConfig, FHIRPageableObjectFactory) {
        return angular.extend({}, angular.copy(RequestService), {
            url: BaseFHIRConfig.getUrl(),
            type: '',
            getUrl: function (id) {
                id = id ? '/' + id : '';

                return this.url + this.type + id;
            },

            read: function (id) {
                if (!id) {
                    throw new Error('An ID must be supplied for a read request');
                }

                return this.sendRequest({
                    method: 'GET',
                    url: this.getUrl(id)
                });
            },

            create: function (resource) {
                if (!(resource && typeof resource === 'object')) {
                    throw new Error('A resource object must be supplied for a create request');
                }

                if (resource.id) {
                    throw new Error('An ID element must not be supplied in the resource body on a create request');
                }



                return this.sendRequest({
                    method: 'POST',
                    url: this.getUrl(),
                    data: resource
                });
            },

            update: function (resource) { 
                if (!(resource && typeof resource === 'object')) {
                    throw new Error('A resource object must be supplied for an update request');
                }

                if (!resource.id) {
                    throw new Error('An ID element must be supplied in the resource body on an update request');
                }


                return this.sendRequest({
                    method: 'PUT',
                    url: this.getUrl(resource.id),
                    data: resource




                });



            },

            delete: function (id) {
                if (!id) {
                    throw new Error('An ID must be supplied for a delete request');
                }

                return this.sendRequest({
                    method: 'DELETE',
                    url: this.getUrl(id)
                });
            },

            search: function (params) {
                return this.sendRequest({
                    method: 'GET',
                    url: this.getUrl(),
                    params: params
                }).then(function (response) {
                    return FHIRPageableObjectFactory.createPageableObject(response);
                });           
            }
        });
    };
});